function [obj, grad] = myIneqConFunctionwSlackJacobianAD(inputVariables, extraParams, params)
%myIneqConFunctionwSlackJacobianAD Compute objective function value and
%gradient
%
%   OBJ = myIneqConFunctionwSlackJacobianAD(INPUTVARIABLES, EXTRAPARAMS,
%   PARAMS) computes the objective value OBJ at the point INPUTVARIABLES,
%   using the extra parameters in EXTRAPARAMS and parameters in PARAMS.
%
%   [OBJ, GRAD] = myIneqConFunctionwSlackJacobianAD(INPUTVARIABLES,
%   EXTRAPARAMS, PARAMS) additionally computes the objective gradient
%   value GRAD at the current point.
%
%   Auto-generated by prob2struct on 08-May-2023 12:35:14

%#codegen
%#internal
%% Variable indices.
eidx = 5:6;
xidx = 1;

%% Map solver-based variables to problem-based.
e = inputVariables(eidx);
e = e(:);
x = inputVariables(xidx);

%% Compute objective function.
arg1 = zeros(2, 1);
arg1(1) = (((-x) + 20) - e(1));
arg1(2) = ((x - 22) - e(2));
obj = arg1(:);

if nargout > 1
    %% Compute objective gradient.
    % To call the gradient code, notify the solver by setting the
    % SpecifyObjectiveGradient option to true.
    arg11 = zeros(6, 2);
    ejac = zeros(2, 2);
    xjac = zeros(1, 2);
    arg4 = eye(2);
    arg5 = arg4(2,:);
    arg6 = (-arg5);
    arg7 = zeros(2, 2);
    arg7(2,:) = arg6;
    ejac = ejac + arg7;
    xjac = xjac + arg5;
    arg8 = arg4(1,:);
    arg9 = (-arg8);
    arg10 = zeros(2, 2);
    arg10(1,:) = arg9;
    ejac = ejac + arg10;
    xjac = xjac + (-arg8);
    arg11(eidx,:) = ejac;
    arg11(xidx,:) = xjac;
    grad = (reshape(arg11, [6, 2]))';
end
end