function out = get_slddVal(sldd_name, val_name)
%% Copyright 2022 The MathWorks, Inc.
%%
sldd_obj = Simulink.data.dictionary.open(sldd_name);
data_set_obj = getSection(sldd_obj, 'Design Data');
data_entry = getEntry(data_set_obj, val_name);
ts_obj = getValue(data_entry);
out = ts_obj.Value;

if isa(out, "Simulink.data.Expression")
    model_name = 'get_slexpr_value';
    load_system(model_name);
    set_param(model_name, 'DataDictionary', sldd_name);
    
    set_param('get_slexpr_value/Simulink_Parameter', ...
        'Value', val_name);
    simout = sim('get_slexpr_value');
    out = simout.yout{1}.Values.Data;

    close_system('get_slexpr_value', 0);
end

end
