# 学習器で学習させたモデルをSimulinkへ実装する方法
# 目的


Statistics and Machine Learning Toolboxの分類学習器アプリや回帰学習器アプリで学習させたモデルをSimulinkで使えるようにする。




加えて、SimulinkでEmbedded Coderを用いたCコード生成ができるようにする。


# 対応バージョン


R2020b


## 使用するツールボックス

   -  MATLAB 
   -  Simulink 
   -  Statistics and Machine Learning Toolbox 
   -  MATLAB Coder 
   -  Simulink Coder 
   -  Embedded Coder 

# 学習器アプリで学習


データを読み込む。



```matlab:Code
load('vehicleData.mat');
```



回帰学習器アプリを開き、モデルを学習させる。




回帰のため、数値データのみにチェックを入れ、セッションを開始する。




![image_0.png](ReadMe_images/image_0.png)




任意のモデルで学習させる。ここでは、ツリーとSVMを学習させた。




![image_1.png](ReadMe_images/image_1.png)




モデルをエクスポートする。以下のどちらを用いても問題ない。




![image_2.png](ReadMe_images/image_2.png)




以下のようにワークスペースにエクスポートされる。




![image_3.png](ReadMe_images/image_3.png)




SVN以外のモデルは、以下のコマンドを実行し、モデルをファイルに保存する。



```matlab:Code
saveLearnerForCoder(trainedModel_tree.RegressionTree, 'trainedModel_tree.mat');
```

# Simulinkモデルへ実装


'ctrl_model.slx'を開く。



```matlab:Code
open_system('ctrl_model');
```



SVN以外のモデルは、MATLAB Functionを用いて実装する。MATLAB Functionブロックを開いて確認すること。“loadLearnerForCoder”コマンドを用いて回帰モデルを読み込んでいる。




Simulinkのベクトルは基本的に列ベクトルだが、機械学習モデルには行ベクトルを入力しなければならないため、転置処理も必要になる。




SVNのモデルはRegressionSVM Predictブロックにて、ワークスペースの変数オブジェクトを直接参照することができる。RegressionSVM Predictブロックのブロックパラメータを確認すること。




'system_model.slx'を開いて実行する。



```matlab:Code
open_system('system_model');
sim('system_model');
```

# コード生成


'ctrl_model.slx'は、Embedded Coderによるコード生成が可能である。



```matlab:Code
rtwbuild('ctrl_model');
```



モデルによっては、コンフィギュレーションパラメータで「可変サイズの信号」にチェックを入れる必要がある。




![image_4.png](ReadMe_images/image_4.png)


