%% Script to demonstrate driving a SimEvent models using data imported from
% an EXCEL spreadsheet, and writing results back to EXCEL

%% Import data and initialise variables
importSimData;              % Automatically generated using Import Tool
mdl = 'Lunchline1_param.slx';
resultsFilename = 'SimResults.xlsx';
figure(1);
plotnum = 1;   
numSims = length(NumServers);
%% Run simulations, plot results, and write to XLS file

for i = 1:numSims
    % Define simulation data
    simMean = Mean_ServiceTime(i);
    simSTD = STD_ServiceTime(i);
    simServers = NumServers(i);
   
    % Run simulation.  Data is saved to workspace as "simout".
    sim(mdl);
    
    % Plot Queue
    subplot(numSims,1,plotnum);
    stairs(simout.time,simout.signals.values);
    title(['Queue length for NumServers = ' num2str(simServers)]);
    xlabel('Time')
    
    % Increment plot number
    plotnum = plotnum+1;
    
    % Write Results to EXCEL spreadsheet
    sheetname = ['NumServers ' num2str(simServers)];
    xlswrite(resultsFilename,[simout.time simout.signals.values],sheetname,'A1')
    xlswrite(resultsFilename,{'Mean:',simMean},sheetname,'D1')
    xlswrite(resultsFilename,{'StdDev:',simSTD},sheetname,'D2')

end



