function finalResult = optimizationBatchProcess()
% genetic algorithm solver has mixed integer support
% Find optimial resource capacities of a chemical production system.
%  Apply Genetic Algorithm solver of MATLAB Global Optimization Toolbox and
%  SimEvents Discrete-Event Simulation to find optimal resource capacties of
%  a chemical production 

% The genetic algorithm solves optimization problems by repeatedly 
% modifying a population of individual points. Due to its random nature, 
% the genetic algorithm improves your chances of finding a global solution. 
% It does not require the functions to be differentiable or continuous.

% Setting plot and parallelization options
opts = gaoptimset('PlotFcns',@gaplotbestf,'UseParallel',true,'PopulationSize',15);

% Define decision variables vector
% vecX(1) = Number of Batch Reactors
% vecX(2) = Capacity of Water Supply
% vecX(3) = Capacity of Heat Supply
% vecX(4) = Capacity of Draining Facility

% Lower bound of decision variables
lb = [1 1 1 1];
% Upper bound of decision variables
ub = [20 5 5 5];

% Integer constraints
% If the third was not an integer, it would be [1, 2, 4]
IntCon = [1 2 3 4];

% Execute genetic algorithm solver
finalResult = ga(@productionCost,4,[],[],[],[],...
    lb,ub,[],IntCon,opts);                                                  

% Cost function that assign different values to the decision variables in
% the model
    function obj = productionCost(vecX)
        cost = [100 200 200 200]*vecX';
        assignin('base','x',vecX);
        [~,~,z] = sim('batchProcess_optim');
        backlog = z(end);
        obj = backlog*10000+cost;
    end

end