matlab_code_kit
===============

A kit of useful MATLAB code, such as doubly-linked lists, FIFO queues, random rapidly-exploring trees, and quad trees.

Contents:
---------

##### Algoritms (mcodekit.algorithm)
+ Collision detector based on GJK distance algorithm (GjkCollisionDetector)
+ Extended Kalman filter
+ Particle (bootstrap) filter

##### Geometry (mcodekit.geometry)
+ 2D Line (Line2D)
+ 2D Vector (Vector2D)
+ 2D Surface (Surface2D)

##### Lists (mcodekit.list)
+ Doubly-linked list (dl_list_*)

##### Queues (mcodekit.queue)
+ First in, first out queue (fifo_queue)

##### Systems (mcodekit.system)
+ Stochastic system
+ Filtered system

##### Trees (mcodekit.tree)
+ Quad Tree (quad_tree_*)
+ Left Child, Right Sibling tree (lcrs_tree_*)
+ Rapidly-exploring dense tree (r_dense_tree)